/////////////////////////////////////////////////////////////////////////////////
// Original obtained from ShaderToy.com
// Adapted, from https://www.shadertoy.com/view/mlfXzn by Calgon



uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels




// Use defines here rather than edit the body of the code.


#define iTime u_Elapsed*2.4
#define iResolution u_WindowSize


#define iMouse AUTO_MOUSE  //vec4(0.0,0.0,0.0,0.0)

// Simple "Automatic Mouse". Simulates scanning the mouse over the full range of
// the screen with the X and Y scanning frequencies being different. TheEmu.

#define MOUSE_SPEED vec2(0.5,0.577777) * 0.2
#define MOUSE_POS vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
#define MOUSE_PRESS vec2(1.0,1.0)
#define AUTO_MOUSE vec4( MOUSE_POS, MOUSE_PRESS )



/////////////////////////////////////////////////////////////////////////////////
// Scene Input variables
uniform float uvx_offset; // Offset the output x 
uniform float uvy_offset; // Offset the output y
uniform float background; // Toggle foregroud/background 
uniform vec4 diskColour; // Basic colour of the disk

uniform float dR; // Basic colour of the disk
uniform float dG; // Basic colour of the disk
uniform float dB; // Basic colour of the disk

vec4 diskCol3 = vec4(dR,dG,dB,1.0);


/////////////////////////////////////////////////////////////////////////////////
// As per Shadertoy
// https://www.shadertoy.com/view/mlfXzn


const float PI = 3.14159265;


vec2 hash2( vec2 p )
{
	// texture based white noise
//	return texture( iChannel0, (p+0.5)/256.0, -100.0 ).xy;
	
    // procedural white noise	
	return fract(sin(vec2(dot(p,vec2(127.1,311.7)),dot(p,vec2(269.5,183.3))))*43758.5453);
}

vec3 voronoi( in vec2 x )
{
    vec2 n = floor(x);
    vec2 f = fract(x);

    //----------------------------------
    // first pass: regular voronoi
    //----------------------------------
	vec2 mg, mr;

    float md = 8.0;
    for( int j=-1; j<=1; j++ )
    for( int i=-1; i<=1; i++ )
    {
        vec2 g = vec2(float(i),float(j));
		vec2 o = hash2( n + g );
        o = 0.5 + 0.5*sin( iTime + 6.2831*o );
        vec2 r = g + o - f;
        float d = dot(r,r);

        if( d<md )
        {
            md = d;
            mr = r;
            mg = g;
        }
    }

    //----------------------------------
    // second pass: distance to borders
    //----------------------------------

    md = 8.0;
    for( int j=-2; j<=2; j++ )
    for( int i=-2; i<=2; i++ )
    {
        vec2 g = mg + vec2(float(i),float(j));
		vec2 o = hash2( n + g );
        o = 0.5 + 0.5*sin( iTime + 6.2831*o );
        vec2 r = g + o - f;

        if( dot(mr-r,mr-r)>0.00001 )
        md = min( md, dot( 0.5*(mr+r), normalize(r-mr) ) );
    }


    return vec3( md, mr );
}


float sphere(float t, float k)
{
    float d = 1.0+t*t-t*t*k*k;
    if (d <= 0.0)
        return -1.0;
    float x = (k - sqrt(d))/(1.0 + t*t);
    return asin(x*t);
}


void mainImage( out vec4 fragColor, in vec2 fragCoord )
{
    // bg texture
   //vec4 texColor = texture(iChannel0, fragCoord.xy / iResolution.xy);
    vec4 texColor = vec4 (0.);
	
  	vec2 uv = fragCoord.xy - 0.5*iResolution.xy;
    // Calgon
    uv.y *= 5. +uvy_offset;
    uv.x *= 0.38;
    
    
    
    float v = iResolution.x;
    if (v > iResolution.y)
        v = iResolution.y;
	uv /= v;

	// Mkae the disc grow
	float uv_grow_start = 80.;
	float uv_grow = clamp(uv_grow_start, 3., uv_grow_start - u_Elapsed*20);
	
	
    uv *= 3.0;
	
//	uv *= uv_grow;
	
	
    uv.y += 6.25;
	
	
	
	
	
	
//	uv.x += sin(u_Elapsed*.3)*.3;
//	uv.y += sin(u_Elapsed*.9)*.5;
    
    
    
    float len = length(uv);
    float k = 1.0;
    float len2;

    len2 = sphere(len*k,sqrt(2.0))/sphere(1.0*k,sqrt(2.0));
	uv = uv * len2 * 0.5 / len;
	uv = uv + 0.5;
	/*if (len2 < 0.0 || uv.x < 0. || uv.y < 0. || uv.x > 1. || uv.y > 1.)
	{
		fragColor = texColor;
		return;
	}*/
    
    vec2 pos = uv;
    float t = iTime/1.0;
    float scale1 = 40.0;
    float scale2 = 20.0;
    float val = 0.0;
    
    val += sin((pos.x*scale1 + t));
    val += sin((pos.y*scale1 + t)/2.0);
    val += sin((pos.x*scale2 + pos.y*scale2 + sin(t))/2.0);
    val += sin((pos.x*scale2 - pos.y*scale2 + t)/2.0);
    val /= 2.0;


    vec3 c = voronoi(64.0*pos );

	// isolines
    val += 2.0*sin(t)*c.x*(0.5 + 0.5*sin(64.0*c.x));
    
  //  float glow = 0.020 / (0.015 + distance(len, 1.0));
  float glow = 0.040 / (0.015 + distance(len, 1.0));
  
  
    
    val = (cos(PI*val) + 1.0) * 0.5;
    vec4 col2 = vec4(0.3, 0.7, 1.0, 1.0);
//	col2.r = dR;
	col2 = diskCol3;
	
	
//	col2 = vec4(1.0, 0.2, 0.2, 1.0);
	
//	col2 = diskColour;
//	col2.a = 1.0;
	
	
	
    
//    fragColor = step(len, 1.0) * 0.5 * col2 * val + glow * col2 + 0.5 * texColor;
	
	fragColor = step(len, 1.0) * 0.5 * col2 * val + glow * col2 ;
	
    
    // Calgon
    float grey = (fragColor.r + fragColor.g + fragColor.b)/3.;
	//fragColor.a = smoothstep(0.0, 0.15, grey);	// Remove Alpha for all Black parts
	// OR
	fragColor.rgb *= 1.5;
	
	
	
	
	
	
	
//	fragColor.b *= 1.5;
	fragColor.a = fragColor.b;	// Remove Alpha for all Black parts
	
	float fadeIn = clamp(iTime/5., 0.,1.);
	fragColor.a *= fadeIn;
	
	
	
//	if (grey < 0.2){
//		fragColor.a *= grey;
//	}
    
	
	
	
    
    
}

/////////////////////////////////////////////////////////////////////////////////


void main ( void )
{
   mainImage ( gl_FragColor, gl_FragCoord.xy );
   // gl_FragColor.a = 1.0;
}
